unit UtilUnit;

interface

uses
  Variants, SysUtils;

function IntToStrWithZeros(Value: Int64; W: Byte): string;

function BinToInt(Value: string): Int64;

function IntToBin(Value: Int64; Digits: integer): string;

function Base64Decode(Value: WideString): WideString;

function Base64Encode(Value: AnsiString): WideString;

function Rounding(Value: Currency): Currency;

function GetStatusTextById(id: byte): string;

function GetInvoiceTypeById(id: byte): string;

function GetDocumentTypeByCode(code: SmallInt): string;

implementation

function Rounding(Value: Currency): Currency;
begin
  if Value < 0 then
    Result := Trunc(Value * 100 - 0.5) / 100
  else
    Result := Trunc(Value * 100 + 0.5) / 100;
end;

function IntToStrWithZeros(Value: Int64; W: Byte): string;
var
  i, c: Smallint;
begin
  Result := IntToStr(Value);
  c := W - (Length(Result));
  for i := 1 to c do
  begin
    Result := '0' + Result;
  end;
end;

function BinToInt(Value: string): Int64;
var
  i: Integer;
begin
  Result := 0;

 //   
  while Copy(Value, 1, 1) = '0' do
    Value := Copy(Value, 2, Length(Value) - 1);
 // 
  for i := Length(Value) downto 1 do
    if Copy(Value, i, 1) = '1' then
      Result := Result + (1 shl (Length(Value) - i));
end;

function IntToBin(Value: Int64; Digits: integer): string;
begin
  result := StringOfChar('0', Digits);
  while Value > 0 do
  begin
    if (Value and 1) = 1 then
      result[Digits] := '1';
    dec(Digits);
    Value := Value shr 1;
  end;
end;

function Base64Encode(Value: AnsiString): WideString;
var
  binStr: WideString;
  char: AnsiChar;
  i: Integer;
  base: string;
begin
  base := 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
  binStr := NullAsStringValue;
  for i := 1 to Length(Value) do
  begin
    char := Value[i];
    binStr := binStr + IntToBin(Ord(char), 8);
  end;

  Result := NullAsStringValue;
  i := 1;
  while i <= Length(binStr) do
  begin
    Result := Result + base[BinToInt(Copy(binStr, i, 6)) + 1];
    i := i + 6;
  end;
end;

function Base64Decode(Value: WideString): WideString;
var
  i: Integer;
  base: string;
  binStr: WideString;
begin
  base := 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
  binStr := NullAsStringValue;

  for i := 1 to Length(Value) do
  begin
    binStr := binStr + IntToBin(ANSIPos(Value[i], base) - 1, 6);
  end;

  Result := NullAsStringValue;
  i := 1;
  while i <= Length(binStr) do
  begin
    Result := Result + chr(BinToInt(Copy(binStr, i, 8)));
    i := i + 8;
  end;
end;

function GetStatusTextById(id: byte): string;
begin
  case id of
    0:
      Result := ' ';
    1:
      Result := ' ';
    2:
      Result := ' .';
    3:
      Result := '';
    4:
      Result := ' ';
    5:
      Result := '.';
    6:
      Result := '';
    7:
      Result := '.';
    8:
      Result := ' ';
    9:
      Result := '';
  else
    Result := ' ';
  end;
end;

function GetInvoiceTypeById(id: byte): string;
begin
  case id of
    1:
      Result := '';
    2:
      Result := '';
    3:
      Result := '';
    4:
      Result := '.  ';
  else
    Result := '  ';
  end;
end;

function GetDocumentTypeByCode(code: SmallInt): string;
begin
  case code of
    600:
      Result := ' ';
    601:
      Result := '';
    602:
      Result := '-2';
    603:
      Result := '-1';
    604:
      Result := '';
    605:
      Result := '';
    606:
      Result := '';
    607:
      Result := 'CMR-';
    608:
      Result := '-';
    609:
      Result := 'Invoice ()';
    610:
      Result := '';
    611:
      Result := ' ';
    612:
      Result := '  ';
    613:
      Result := '';
    614:
      Result := ' -1';
    615:
      Result := ' -2';
  else
    Result := '  ';
  end;
end;

end.

